
;		Test program for 2 TRW-24G RF modules connected 1 to PortB and 1 to PortD of an 
;		AT90s2313 at 4MHz. AVR is send 4 bytes through the 1st RF module. 2nd RF module receive
;		this bytes and AVR read them and send them to PC via RS232 hardware serial port (PD1)
;		
;				Device:		AT90S2313 at 4MHz crystal,
;							and 2 x TRW-24G RF devices (2.4 GHz)
;				Author:		Serasidis Vasilis
;				Date:		24.07.2005
;				Home page:	http://www.serasidis.gr
;				emails:		info@serasidis.gr, avrsite@yahoo.gr

;				Writed with AVRstudio 4.10




.include "2313def.inc"

;1st TRW-24G -> AVR (portB pins)
.equ	DATA1	=0		
.equ	CS1		=1
.equ	CE1		=2
.equ	CLK1	=3
.equ	DR1		=4

;2nd TRW-24G -> AVR (PortD pins)
.equ	DATA2	=2
.equ	CS2		=3
.equ	CE2		=4
.equ	CLK2	=5
.equ	DR2		=6

.equ	BAUD	=24 		;9600 bps at 4 MHz (hardware UART)

.def	temp	=r16
.def	temp2	=r17
.def	count	=r18
.def	txbyte	=R19		;Data to be transmitted
.def	rxbyte	=R20		;Received data
.def	bitcnt	=r21


		ldi		temp,RAMEND
		out		SPL,temp		;Init Stack Pointer

		ldi		temp,0b11101111 ;port B output, PB4 input
		out		DDRB,temp
		ldi		temp,0b00000000	;
		out		PORTB,temp

		ldi		temp,0b00111110 ;port D output, PD0,PD6 inputs
		out		DDRD,temp
		ldi		temp,0b00000000	;
		out		PORTD,temp

		ldi		temp, BAUD
		out		UBRR, temp	;Set baud rate generator

;===========   Set UART, as Transmiter   =====================
		ldi		temp,0b00011000
		out		UCR,temp	;Enable UART Tx w/o interrupts
;==============================================================

		cbi		portD,CE2	;Clear CE2 pin
		sbi		portD,CS2	;Set CS2 pin
		rcall	loadbyte2	;make device2 receiver
		cbi		portD,CS2	;Clear CS2 pin
		sbi		portD,CE2	;Set CE2 pin

		cbi		portB,CE1	;Clear CE1 pin
		sbi		portB,CS1	;Set CS1 pin
		rcall	loadbyte1	;make device1 transmitter
		cbi		portB,CS1	;Clear CS1 pin

Send_bytes_to_receiver:

		sbic	pind,DR2	;Is any new data in receiver's buffer ?
		rjmp	send_to_PC	;If yes, go to "send_to_PC" address
							;if not, continue.

		sbi		portb,CE1	;Set CE1 pin high
		ldi		txbyte,$AA	;Set the address of the receiver module: $AA, $BB, $CC, $DD, $EE
		rcall	transmit_byte
		ldi		txbyte,$BB
		rcall	transmit_byte
		ldi		txbyte,$CC
		rcall	transmit_byte
		ldi		txbyte,$DD
		rcall	transmit_byte
		ldi		txbyte,$EE
		rcall	transmit_byte
		ldi		txbyte,$31			;Set the payload bytes $31, $32, $33, $34
		rcall	transmit_byte
		ldi		txbyte,$32
		rcall	transmit_byte
		ldi		txbyte,$33
		rcall	transmit_byte
		ldi		txbyte,$34
		rcall	transmit_byte
	
		cbi		portb,CE1			;Send address and payload bytes (over the air) to receiver.
		rcall	delay
		rcall	delay	

		rjmp	Send_bytes_to_receiver


;============================================================================================
send_to_PC:
		ldi		count,4			;4 bytes length

send_all_bytes:
		rcall	read_RF_module	;read received byte from RF module
		rcall	UART_transmit	;and transmit it to PC via serial port (at 9600 bps)
		dec		count			; have you read all bytes from RF module ?
		brne	send_all_bytes	; if not, go to read next
here:							; if yes, stay here for ever.
		rjmp	here
;============================================================================================

loadbyte1:
		ldi		count,15			;15 bytes length
from_send:
		ldi		ZH,high(2*message1)	;Load High byte of Flash memory to ZH
		ldi		ZL,low(2*message1)	;Load Low byte of Flash memory to ZL

next_byte:
		lpm							; Load byte from program memory into r0
		mov		txbyte,r0			;move byte from program memory (r0), to txbyte register.
		rcall	transmit_byte	

		adiw	ZL,1				; Increase Z register
		dec		count				; Check if we've reached the end of the message (byte 16)
		brne	next_byte				; If so, quit

		ret
;------------------------------------------
loadbyte2:
		ldi		count,15			;15 bytes length
		ldi		ZH,high(2*message2)	;Load High byte of Flash memory to ZH
		ldi		ZL,low(2*message2)	;Load Low byte of Flash memory to ZL

next_byte2:
		lpm							; Load byte from program memory into r0
		mov		txbyte,r0			;move byte from program memory (r0), to txbyte register.
		rcall	transmit_byte2	

		adiw	ZL,1				; Increase Z register
		dec		count				; Check if we've reached the end of the message (byte 16)
		brne	next_byte2				; If so, quit

		ret
;-------------------------------------------



message1: ;Configuration of transmitter
.db 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xA3, 0x4C, 0x04, 0x00

message2: ;Configuration of receiver
.db 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xA3, 0x4C, 0x05, 0x00


.db "(c) 24.07.2005 by Serasidis Vasilis. http://www.serasidis.gr"



;--------------------------------------------------------------------------
;			Send 1 byte to 1st RF module
;--------------------------------------------------------------------------

transmit_byte:

		ldi		bitcnt,8 
		sbi		DDRD,DATA1		;make DATA1 pin output

putchar0:
		lsl		Txbyte		;Get next bit
		brcc	putchar1	;If carry set
		sbi		PORTB,DATA1	;    send a '1'
		rjmp	putchar2	;else	

putchar1:
		cbi		PORTB,DATA1	;send a '0'
		nop

putchar2:
		sbi		portb,CLK1
		cbi		portb,CLK1
		dec		bitcnt		;If not all bit sent
		brne	putchar0	;send next

		ret					;return

;--------------------------------------------------------------------------
;			Send 1 byte to 2nd RF module
;--------------------------------------------------------------------------

transmit_byte2:

		ldi		bitcnt,8 
		sbi		DDRD,DATA2		;make DATA2 pin output

putchar02:
		lsl		Txbyte		;Get next bit
		brcc	putchar12	;If carry set
		sbi		PORTd,DATA2	;    send a '1'
		rjmp	putchar22	;else	

putchar12:
		cbi		PORTd,DATA2	;send a '0'
		nop

putchar22:
		sbi		portd,CLK2
		cbi		portd,CLK2
		dec		bitcnt		;If not all bit sent
		brne	putchar02	;send next


		ret					;return

;--------------------------------------------------------------------------
;------------------      Reading of the RF module       -------------------
;--------------------------------------------------------------------------	
Read_RF_module:	
	
		clr		txbyte
		ldi		bitcnt,8		;8 bits length for the byte
		cbi		DDRD,DATA2		;make DATA2 pin input
		sbi		PORTD,DATA2		;Enable pullup resistor on DATA2 pin.

next_bit:
		rol		txbyte			;Rotate left the txbyte register
		sbi		PortD,clk2		;Set the clock pin	
		sbic	PIND,DATA2		;Read if the data pin, is '1'
		sbr		txbyte,0x01		;If yes, make '1' the 1st bit of txbyte register
		cbi		PortD,clk2		;Clear the clock pin
		dec		bitcnt			;Decrease by 1 the bitcnt register
		brne	next_bit		;If bitcnt register is not 0, go to next_bit
		ret						;return

;--------------------------------------------------------------------------
; Transmiting routine (The data from RF module -through the AVR- are going
; to PC computer)         
;--------------------------------------------------------------------------
UART_transmit:	
		sbis	USR,UDRE		;is UART transmitter ready?
		rjmp	UART_transmit
		out		UDR,txbyte		;send out char
		ret

;--------------------------------------------------------------------------
; Receiving routine (The data from PC computer -through the AVR- are going
; to RF module)  
;--------------------------------------------------------------------------
UART_receive:
		sbis	USR,RXC
		rjmp	UART_receive
		in		rxbyte,UDR
		out		portb,rxbyte
		ret

;--------------------------------------------------------------------------

delay:
		ldi		temp2,50
decrease2:
		ldi		temp,255
decrease1:
		dec		temp
		brne	decrease1
		dec		temp2
		brne	decrease2
		ret
